
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1180.C - Message 1180 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Boot 1180 messages for flash reprogramming.
//
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h" 
#include "labmon.h"

void wait(float);  
void clear_command_line(void);   

extern void SendRFBBlock(unsigned short);
extern short FlashMode;
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1180 message from the ZMsgBuf.
//
void Dec1180(tMSGBUF *ZMsgBuf, tMSG1180 *Msg)
{
;
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1180 message in the ZMsgBuf. 
//
void Bld1180(tMSGBUF *ZMsgBuf, tMSG1180 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                        , ZMsgBuf, 1);  // message preamble
   PutShort  (1180                          , ZMsgBuf, 2);  // message number
   PutShort  (1                             , ZMsgBuf, 3);  // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);  // message ack/nack request
 //PutShort  (CheckSum(ZMsgBuf[0], 4)       , ZMsgBuf, 5);  // header check sum
                                                            
 //PutShort  (CheckSum(ZMsgBuf, 6, 7)       , ZMsgBuf,13);  // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1180 message from the ZMsgBuf.
//
void Show1180(tMSG1180 *Msg)
{
   char    Buf[100] = "";
   char    *StatusName[10] =
            {"FLASH CHECKSUM PASSED", "FLASH CHECKSUM FAILED", "ERASING FLASH", 
            "FLASH ERASE FAILED", " ", "FLASH REPROGRAM FAILED",
            "FLASH REPROGRAM COMPLETE", "FLASH ERASE DONE", "RESEND INIT BLOCK", "RESEND BLOCK"}; 

   // perform special processing for output
   if(Msg->StatusNumber != 4) {
      sprintf(Buf,"MSG 1180: STATUS: %s ",StatusName[(short) Msg->StatusNumber]); 
   
      // output the data items   
      clear_command_line();                                                                                               
      ShowText(Buf, CMDR-1, CMDC);  
      wait(.5f);     
   }  
   
   switch (Msg->StatusNumber) {
   
      case 2:
		 clear_screen();
         SendRFBBlock(0);
         break;
      default: 
         Send_RFB();
         break;   
   }  
}                                                 


////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1180 message from the ZMsgBuf.
//
//void Show1180(tMSG1180 *Msg)
//{
//   char    Buf[100] = "";
//   char    *StatusName[7] =
//            {"CHECKSUM PASSED", "CHECKSUM FAILED", "COPYING LOADER", 
//            "WAITING FOR COMMAND", "SEND NEXT BLOCK", "RESEND LAST BLOCK",
//            "UPLOAD COMPLETE"}; 

   // perform special processing for output
//   sprintf(Buf,"MSG 1180: STATUS: %s ",StatusName[(short) Msg->StatusNumber]); 
   
   // output the data items   
//   clear_command_line();                                                                                               
//   ShowText(Buf, CMDR-1, CMDC);  
//   wait(.5f);
//}                                                 
                                      
                                           
